/////////////////////////////////////////下方处理form数据///////////////////////////////////////////////////////
function checkVIP(url,form) {
    var XHR = new XMLHttpRequest();
    // Bind the FormData object and the form element
    var formData = new FormData(form);
    // Define what happens on successful data submission
    XHR.addEventListener("load", function(event) {//全部资源加载结束才获取
      var responseInfo = JSON.parse(event.target.responseText);
      // console.log(responseInfo['serviceEndDate'],responseInfo['userName']);
      if(responseInfo['serviceEndDate']!=null){
        chrome.storage.sync.set({
          'userName': responseInfo['userName'],
          'serviceEndDate': responseInfo['serviceEndDate']
        }); //存该格式的数据2016-11-19  chrome.storage.sync.remove('DisabledDate')
        document.querySelector('p').innerHTML='你的VIP服务期截止于'+responseInfo['serviceEndDate'];//可替换为restore_options();
      }else{
        document.querySelector('p').innerHTML='非VIP用户名，如已购买并且还在有效期内，请联系 mathjoy@139.com 需求帮助；<br/>如未购买，请考虑<a href="https://www.cnblogs.com/iMath/p/17128407.html"  title="付费用户才会有VIP用户名">购买支持本软件</a>，你的支持是本软件继续为你提供便捷下载服务的动力！';
      }
    });
    // Define what happens in case of error
    XHR.addEventListener("error", function(event) {
      document.querySelector('p').innerHTML='出问题了，请联系软件作者 mathjoy@139.com';//,
      console.log(event.target.responseText,event.target.statusText);
    });
    // Set up our request
    XHR.open("POST",url );
    // The data sent is what the user provided in the form
    XHR.send(formData);
}


document.querySelector('form').addEventListener("submit", function (event) {
  event.preventDefault();// 防止提交后页面刷新，为了用户体验
  checkVIP("https://mathjoy.eu.org/VideoParser/isVipUser/",event.target)
  // checkVIP("http://127.0.0.1:8000/VideoParser/isVipUser/",event.target)
});

///////////////////////////////////////下方处理信息页的信息恢复展示问题/////////////////////////////////////////////////////////
function restore_options() {
  // Use default value color = 'red' and likesColor = true.
  chrome.storage.sync.get({
    'userName': 'free',//free是缺省值
    'serviceEndDate': (new Date()).toISOString().slice(0, 10)//存该格式的数据2016-11-19  chrome.storage.sync.remove('serviceEndDate')
  }, function(items) {
    // console.log( items['userName']);
    if (items['userName'] != 'free'){
       document.querySelector('#userNameEdit').value = items['userName'];
       document.querySelector('p').innerHTML='你的VIP服务期限至'+items['serviceEndDate'];
    }
  });
}

window.addEventListener("load", function () {//用document竟然不行
  restore_options();
});

